--[[---------------------------------------------------------------------------
	Chocolatier Two High Scores dialog - local only version
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-- Look to submit a new high score
if GetNumUsers() > 0 and not gSim then Simulator:LoadGame() end
if gSim then gSim:LogScore() end

local localOnly = bsgCheckConfig("local")

local HighlightColor = YellowColor

-------------------------------------------------------------------------------

local hugeH = 30
local largeH = 24
local standardH = bsgFontHeight(standardFont)
local kScoreH = 22

local ScoreFont = { standardFontName, kScoreH, BlackColor }
local smallFont = { standardFontName, kFifteen, BlackColor }
local largeFont = { standardFontName, largeH, BlackColor }
local hugeFont = { standardFontName, hugeH, BlackColor }

-------------------------------------------------------------------------------

local h=bsgFontHeight(dialogFont)

-------------------------------------------------------------------------------

local function DoLocalView() ViewLocal(0) end
local function DoGlobalView() ViewGlobal(0) end
local function DoNextCategory() NextCategory() end
local function DoNextMode() NextMode() end
local function DoPreviousMode() PreviousMode() end

local function DoScrollUp() ScrollUp() end
local function DoScrollDown() ScrollDown() end

local function DoSubmitScore() DisplayDialog { "ui/hiscoresubmit.lua" } end
local function DoSubmitMedals() DisplayDialog { "ui/hiscoresubmit.lua", medalsOnly=true } end

-------------------------------------------------------------------------------

local function ScoreList(y)
	local scores = {}
	for i=1,10 do
		table.insert(scores, Group {
			Text { x=0,y=y,w=34,h=kScoreH,
					name = tostring(i), label = tostring(989+i)..".",
					font = ScoreFont, flags = kHAlignRight + kVAlignCenter,
			},
			
			Bitmap { x=34,y=y+(kScoreH-16)/2, image="image/p1icon", name="p1_"..tostring(i) },

			Text { x=51,y=y,w=kMax,h=kScoreH,
					name = "name"..tostring(i), label = "#name",
					font = ScoreFont, flags = kHAlignLeft + kVAlignCenter,
			},
			
			Text { x=51,y=y,w=kMax-1,h=kScoreH,
					name = "score"..tostring(i), label = "#$99,999,999",
					font = ScoreFont, flags = kHAlignRight + kVAlignCenter,
			},
		})
		y = y + kScoreH
	end
	return Group(scores)
end

-------------------------------------------------------------------------------

MakeDialog
{
	name="highscores",
	Frame
	{
		name="scores", x=kCenter,y=80,w=720,h=320, fit=false, color=DialogColor,
		AppendStyle { font=dialogFont },
		HighScores
		{
			x=0,y=0,w=kMax,h=kMax,

			Text { name="title", x=kCenter,y=0,w=400,h=hugeH, label="highscores_title", font=hugeFont },
			Text { name="mode", x=kCenter,y=hugeH,w=200,h=hugeH, label="mode", font=hugeFont },
			Button { name="nextmode", x=500,y=hugeH, label="next", command=DoNextMode,
					graphics=LeftButtonGraphics, hflip=true, scale=hugeH/64 },
			Button { name="prevmode", x=220-hugeH,y=hugeH, label="prev", command=DoPreviousMode,
					graphics=LeftButtonGraphics, scale=hugeH/64 },

			Button { name="scrollup", x=700,y=hugeH+hugeH-20, command=DoScrollUp,
				graphics=LeftButtonGraphics, rotate=true, scale=20/64, },
			ScoreList(hugeH + hugeH),
			Button { name="scrolldown", x=700,y=hugeH+hugeH+10*kScoreH, command=DoScrollDown,
				graphics=LeftButtonGraphics, rotate=true, hflip=true, scale=20/64, },
		
			TextButton { name="back", x=10,y=hugeH+hugeH+10*kScoreH, label="back", close=true },
		},
	},
}

DoLocalView()
